<?php
/**
 * Aliases for MobileFrontend extension
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'History' => [ 'History' ],
	'MobileCite' => [ 'MobileCite' ],
	'MobileOptions' => [ 'MobileOptions' ],
	'Uploads' => [ 'Uploads' ],
	'MobileDiff' => [ 'MobileDiff' ],
	'MobileMenu' => [ 'MobileMenu' ],
	'MobileLanguages' => [ 'MobileLanguages' ],
	'Nearby' => [ 'Nearby' ],
];

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = [
	'History' => [ 'Geskiedenis' ],
	'Uploads' => [ 'Oplaaie' ],
	'Nearby' => [ 'Naby' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'History' => [ 'تاريخ' ],
	'MobileOptions' => [ 'خيارات_المحمول' ],
	'Uploads' => [ 'مرفوعات' ],
	'MobileDiff' => [ 'فرق_المحمول' ],
	'MobileMenu' => [ 'قائمة_المحمول' ],
	'MobileLanguages' => [ 'لغات_المحمول' ],
	'Nearby' => [ 'قريب' ],
	];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'History' => [ 'تاريخ' ],
	'MobileOptions' => [ 'خيارات_الموبايل' ],
	'Uploads' => [ 'مرفوعات' ],
	'MobileDiff' => [ 'فرق_الموبايل' ],
	'MobileMenu' => [ 'قايمه_الموبايل' ],
	'MobileLanguages' => [ 'لغات_الموبايل' ],
	'Nearby' => [ 'قريب' ],
];

/** Asturian (asturianu) */
$specialPageAliases['ast'] = [
	'Nearby' => [ 'Cercano' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'MobileOptions' => [ 'Настройки_мобильной_версии' ],
	'Uploads' => [ 'Загрузки' ],
	'MobileDiff' => [ 'Сравнение_версий' ],
	'MobileMenu' => [ 'Мобильное_меню' ],
	'Nearby' => [ 'Поблизости' ],
];

/** Azerbaijani (azərbaycanca) */
$specialPageAliases['az'] = [
	'History' => [ 'Tarixçə' ],
	'MobileMenu' => [ 'MobilMenyu' ],
	'MobileLanguages' => [ 'MobilDillər' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'History' => [ 'تاریخچه_گ' ],
	'MobileOptions' => [ 'موبایل_ئی_تنزیمان' ],
	'Uploads' => [ 'بُرز_بوته_ئینان' ],
	'MobileDiff' => [ 'موبایل_ئی_پرک' ],
	'MobileMenu' => [ 'موبایل_ئی_مینو' ],
	'MobileLanguages' => [ 'موبایل_ئی_زبانان' ],
	'Nearby' => [ 'بئ_نزینکی_ئا' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'History' => [ 'ইতিহাস' ],
	'MobileCite' => [ 'মোবাইল_উদ্ধৃতি' ],
	'MobileOptions' => [ 'মোবাইল_বিকল্প' ],
	'Uploads' => [ 'আপলোডসমূহ' ],
	'MobileDiff' => [ 'মোবাইল_পার্থক্য' ],
	'MobileMenu' => [ 'মোবাইল_মেনু' ],
	'MobileLanguages' => [ 'মোবাইল_ভাষাসমূহ' ],
	'Nearby' => [ 'কাছাকাছি' ],
];

/** Catalan (català) */
$specialPageAliases['ca'] = [
	'Nearby' => [ 'A_prop' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'MobileOptions' => [ 'Мобильни_верси_нисяр' ],
	'Uploads' => [ 'Чуйохурш' ],
	'MobileDiff' => [ 'Версеш_юстар' ],
	'MobileMenu' => [ 'Мобилан_меню' ],
	'Nearby' => [ 'Гергахьо' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'History' => [ 'Historie' ],
	'MobileCite' => [ 'Mobilní_citace' ],
	'MobileOptions' => [ 'Mobilní_nastavení' ],
	'Uploads' => [ 'Vaše_soubory' ],
	'MobileDiff' => [ 'Mobilní_rozdíl' ],
	'MobileMenu' => [ 'Mobilní_menu' ],
	'MobileLanguages' => [ 'Mobilní_jazyky' ],
	'Nearby' => [ 'Poblíž' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'History' => [ 'Versionsgeschichte' ],
	'MobileOptions' => [ 'Mobile_Optionen' ],
	'Uploads' => [ 'Hochgeladene_Dateien' ],
	'MobileDiff' => [ 'Mobiler_Unterschied' ],
	'MobileMenu' => [ 'Mobiles_Menü' ],
	'MobileLanguages' => [ 'Mobile_Sprachen' ],
	'Nearby' => [ 'In_der_Nähe' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'History' => [ 'Tarix' ],
	'MobileOptions' => [ 'MobilWeçenegi' ],
	'Uploads' => [ 'Barkerdışi' ],
	'MobileDiff' => [ 'MobilVer' ],
	'MobileMenu' => [ 'MıobilMenu' ],
	'MobileLanguages' => [ 'MobilZıwani' ],
	'Nearby' => [ 'Nezdıra' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'MobileOptions' => [ 'Opcioj_pri_poŝaparato' ],
	'Uploads' => [ 'Alŝutoj' ],
	'MobileMenu' => [ 'Menuo_por_poŝaparato' ],
	'Nearby' => [ 'Apude' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'MobileOptions' => [ 'OpcionesParaMóvil' ],
	'Uploads' => [ 'Subidas' ],
	'Nearby' => [ 'Cerca' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'History' => [ 'Ajalugu' ],
	'MobileOptions' => [ 'Mobiili_suvandid' ],
	'Uploads' => [ 'Üleslaaditud_failid' ],
	'MobileDiff' => [ 'Mobiilierinevus' ],
	'MobileMenu' => [ 'Mobiili_menüü' ],
	'MobileLanguages' => [ 'Mobiilikeeled' ],
	'Nearby' => [ 'Lähikond' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'History' => [ 'تاریخچه' ],
	'MobileOptions' => [ 'گزینه‌های_گوشی_همراه' ],
	'Uploads' => [ 'بارگذاری‌ها' ],
	'MobileDiff' => [ 'تفاوت_گوشی_همراه' ],
	'MobileMenu' => [ 'گزینگان_گوشی_همراه' ],
	'MobileLanguages' => [ 'زبان‌های_گوشی_همراه' ],
	'Nearby' => [ 'درنزدیکی', 'در_نزدیکی' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'Uploads' => [ 'Subidas', 'Cargas' ],
	'Nearby' => [ 'Preto', 'Cerca' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'History' => [ 'היסטוריה' ],
	'MobileOptions' => [ 'הגדרות_נייד', 'הגדרות_פלאפון', 'הגדרות_סלולרי' ],
	'Uploads' => [ 'העלאות' ],
	'MobileDiff' => [ 'השוואה_ניידת' ],
	'MobileMenu' => [ 'תפריט_נייד' ],
	'MobileLanguages' => [ 'שפות_בנייד' ],
	'Nearby' => [ 'בסביבה', 'קרוב' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'History' => [ 'इतिहास' ],
	'MobileOptions' => [ 'मोबाइल_विकल्प' ],
	'MobileLanguages' => [ 'मोबाइल_भाषा' ],
	'Nearby' => [ 'आस-पास' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'History' => [ 'Stawizny' ],
	'MobileOptions' => [ 'Mobilne_opcije' ],
	'Uploads' => [ 'Nahrate_dataje' ],
	'MobileDiff' => [ 'Mobilny_rozdźěl' ],
	'MobileMenu' => [ 'Mobilny_meni' ],
	'MobileLanguages' => [ 'Mobilne_rěče' ],
	'Nearby' => [ 'W_bliskosći' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'History' => [ 'Cronologia' ],
	'MobileOptions' => [ 'OpzioniMobile' ],
	'Uploads' => [ 'Caricamenti' ],
	'MobileDiff' => [ 'DiffMobile' ],
	'MobileMenu' => [ 'MenuMobile' ],
	'MobileLanguages' => [ 'LingueMobile' ],
	'Nearby' => [ 'NelleVicinanze' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'History' => [ '履歴' ],
	'MobileOptions' => [ '携帯機器オプション' ],
	'Uploads' => [ '携帯機器アップロード' ],
	'MobileDiff' => [ '携帯機器差分' ],
	'MobileMenu' => [ '携帯機器メニュー' ],
	'MobileLanguages' => [ '携帯機器言語', '言語' ],
	'Nearby' => [ '付近' ],
];

/** Georgian (ქართული) */
$specialPageAliases['ka'] = [
	'History' => [ 'ისტორია' ],
	'Uploads' => [ 'ატვირთვები' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'History' => [ '역사' ],
	'MobileOptions' => [ '모바일설정' ],
	'Uploads' => [ '올린파일' ],
	'MobileDiff' => [ '모바일차이' ],
	'MobileMenu' => [ '모바일메뉴' ],
	'MobileLanguages' => [ '모바일언어' ],
	'Nearby' => [ '근처' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'History' => [ 'Versiounen' ],
	'MobileOptions' => [ 'Mobil_Optiounen' ],
	'Uploads' => [ 'Eropgeluede_Fichieren' ],
	'MobileDiff' => [ 'Mobilen_Ënnerscheed' ],
	'MobileMenu' => [ 'Mobile_Menü' ],
	'MobileLanguages' => [ 'Mobil_Sproochen' ],
	'Nearby' => [ 'Nobäi' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'History' => [ 'ڤیرگار' ],
	'MobileOptions' => [ 'خوصوٙصیات_موبایلی' ],
	'Uploads' => [ 'سوڤارکئردیا' ],
	'MobileDiff' => [ 'فأرخ_موبایلی' ],
	'MobileMenu' => [ 'نومیار_موبایلی' ],
	'MobileLanguages' => [ 'زوٙنا_موبایل' ],
	'Nearby' => [ 'نئزیک_ڤئ' ],
];

/** Literary Chinese (文言) */
$specialPageAliases['lzh'] = [
	'Nearby' => [ '近郊' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'History' => [ 'Историја' ],
	'MobileOptions' => [ 'МобилниПоставки' ],
	'Uploads' => [ 'Подигања' ],
	'MobileDiff' => [ 'МобилнаРазлика' ],
	'MobileMenu' => [ 'МобилноМени' ],
	'MobileLanguages' => [ 'МобилниЈазици' ],
	'Nearby' => [ 'ВоБлизина' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'History' => [ 'ഹിസ്റ്ററി' ],
	'MobileOptions' => [ 'മൊബൈൽഐച്ഛികങ്ങൾ' ],
	'Uploads' => [ 'അപ്‌ലോഡുകൾ' ],
	'MobileDiff' => [ 'മൊബൈൽവ്യത്യാസം' ],
	'MobileMenu' => [ 'മൊബൈൽമെനു' ],
	'MobileLanguages' => [ 'മൊബൈൽഭാഷകൾ' ],
	'Nearby' => [ 'സമീപസ്ഥം' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'History' => [ 'इतिहास' ],
];

/** Min Nan Chinese (Bân-lâm-gú) */
$specialPageAliases['nan'] = [
	'Uploads' => [ 'Kā--ê_tóng-àn' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'History' => [ 'Geschiedenis' ],
	'MobileOptions' => [ 'MobieleVoorkeuren' ],
	'MobileDiff' => [ 'MobielVerschillen' ],
	'MobileMenu' => [ 'MobielMenu' ],
	'MobileLanguages' => [ 'MobielTalen' ],
	'Nearby' => [ 'InDeBuurt' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'MobileOptions' => [ 'Mobilval' ],
	'Uploads' => [ 'Opplastingar' ],
	'Nearby' => [ 'Nær_her' ],
];

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = [
	'History' => [ 'ਇਤਿਹਾਸ' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'History' => [ 'Historia' ],
	'Nearby' => [ 'W_pobliżu' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'MobileOptions' => [ 'Настройки_мобильной_версии' ],
	'Uploads' => [ 'Загрузки' ],
	'MobileDiff' => [ 'Сравнение_версий' ],
	'MobileMenu' => [ 'Мобильное_меню' ],
	'Nearby' => [ 'Поблизости' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'MobileOptions' => [ 'OpzioniMobile' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = [
	'History' => [ 'Историја' ],
	'MobileCite' => [ 'МобилнеРеференце', 'Мобилне_референце' ],
	'MobileOptions' => [ 'МобилнаПодешавања', 'Мобилна_подешавања' ],
	'Uploads' => [ 'Отпремања' ],
	'MobileDiff' => [ 'МобилнеРазлике', 'Мобилне_разлике' ],
	'MobileMenu' => [ 'МобилниМени', 'Мобилни_мени' ],
	'MobileLanguages' => [ 'МобилниЈезици', 'Мобилни_језици' ],
	'Nearby' => [ 'У_близини', 'Близу', 'Оближње' ],
];

/** Serbian (Latin script) (srpski (latinica)‎) */
$specialPageAliases['sr-el'] = [
	'History' => [ 'Istorija' ],
	'MobileCite' => [ 'MobilneReference', 'Mobilne_reference' ],
	'MobileOptions' => [ 'MobilnaPodešavanja', 'Mobilna_podešavanja' ],
	'Uploads' => [ 'Otpremanja' ],
	'MobileDiff' => [ 'MobilneRazlike', 'Mobilne_razlike' ],
	'MobileMenu' => [ 'MobilniMeni', 'Mobilni_meni' ],
	'MobileLanguages' => [ 'MobilniJezici', 'Mobilni_jezici' ],
	'Nearby' => [ 'U_blizini', 'Blizu', 'Obližnje' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'History' => [ 'Historik' ],
	'MobileDiff' => [ 'Mobil_diff' ],
	'MobileMenu' => [ 'Mobil_meny' ],
	'MobileLanguages' => [ 'Mobil_språk' ],
	'Nearby' => [ 'Nära' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'History' => [ 'Історія' ],
	'MobileOptions' => [ 'Налаштування_мобільної_версії', 'Настройки_мобильной_версии' ],
	'Uploads' => [ 'Мобільне_Завантаження', 'Загрузки' ],
	'MobileDiff' => [ 'Мобільна_різниця_версій', 'Сравнение_версий' ],
	'MobileMenu' => [ 'Мобільне_меню', 'Мобильное_меню' ],
	'Nearby' => [ 'Поблизу', 'Поблизости' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'History' => [ 'تاریخچہ', 'تاریخ' ],
	'MobileCite' => [ 'موبائل_حوالہ' ],
	'MobileOptions' => [ 'اختیارات_موبائل', 'موبائل_اختیارات' ],
	'Uploads' => [ 'اپلوڈ_کردہ' ],
	'MobileDiff' => [ 'موبائل_فرق' ],
	'MobileMenu' => [ 'موبائل_مینو' ],
	'MobileLanguages' => [ 'موبائل_کی_زبانیں' ],
	'Nearby' => [ 'آس_پاس', 'پاس_پڑوس' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'History' => [ 'Lịch_sử' ],
	'MobileOptions' => [ 'Tùy_chọn_di_động' ],
	'Uploads' => [ 'Tập_tin_tải_lên' ],
	'MobileDiff' => [ 'So_sánh_di_động' ],
	'MobileMenu' => [ 'Trình_đơn_di_động' ],
	'MobileLanguages' => [ 'Ngôn_ngữ_di_động' ],
	'Nearby' => [ 'Lân_cận', 'Kề_bên' ],
];

/** Chinese (中文) */
$specialPageAliases['zh'] = [
	'History' => [ '历史', '歷史' ],
	'MobileOptions' => [ '移动版选项', '手機版選項', '行動版選項' ],
	'Uploads' => [ '上传', '上傳', '上載' ],
	'MobileDiff' => [ '移动版差异', '手機版差異', '行動版差異' ],
	'MobileMenu' => [ '移动版菜单', '手機版菜單', '手機版選單', '行動版選單' ],
	'MobileLanguages' => [ '移动版语言', '手機版語言', '行動版語言' ],
	'Nearby' => [ '附近' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'History' => [ '历史' ],
	'MobileOptions' => [ '移动版选项' ],
	'Uploads' => [ '上传' ],
	'MobileDiff' => [ '移动版差异' ],
	'MobileMenu' => [ '移动版菜单' ],
	'MobileLanguages' => [ '移动版语言' ],
	'Nearby' => [ '附近' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'History' => [ '歷史' ],
	'MobileOptions' => [ '行動版選項' ],
	'Uploads' => [ '上載' ],
	'MobileDiff' => [ '手機版差異' ],
	'MobileMenu' => [ '手機版選單' ],
	'MobileLanguages' => [ '手機版語言' ],
	'Nearby' => [ '附近' ],
];
